from typing import List, Optional
from dt_node import DTNode  # Assuming DTNode is defined elsewhere
from pipelines.prompta.oracle import Oracle  # Assuming this is defined as per your setup


class DiscriminationTree:
    def __init__(self, oracle: Oracle):
        self.root = DTNode()
        self.oracle = oracle

    def get_root(self) -> DTNode:
        return self.root

    def sift(self, asp, hard=True) -> DTNode:
        return self.sift_word(asp.get_access_sequence(), hard)

    def sift_word(self, word: List, hard=True) -> DTNode:
        return self._sift_from_node(self.root, word, hard)

    def _sift_from_node(self, start: DTNode, word: List, hard=True) -> DTNode:
        current = start
        while not current.is_leaf() and (hard or not current.is_temp()):
            outcome = self._mq_out(word, current.get_discriminator())
            current = current.get_child(outcome)
        return current

    def least_common_ancestor(self, node1: DTNode, node2: DTNode) -> DTNode:
        depth_diff = node1.get_depth() - node2.get_depth()

        if depth_diff < 0:
            curr1, curr2 = node2, node1
            depth_diff = -depth_diff
        else:
            curr1, curr2 = node1, node2

        for _ in range(depth_diff):
            curr1 = curr1.get_parent()

        while curr1 != curr2:
            curr1 = curr1.get_parent()
            curr2 = curr2.get_parent()

        return curr1

    def _mq_out(self, prefix: List, suffix: List) -> bool:
        # Assuming MQUtil.output(oracle, prefix, suffix) is a way to query the oracle
        # This needs to be adapted based on how MembershipOracle is implemented in Python
        return self.oracle.query(prefix + suffix)  # Simplified for illustration


